<?php
/**
 * WooCommerce Product Reset Filters Widget
 * Reset or apply all filters with single button
 */
class SS_Product_Reset_Filters extends WP_Widget {

	protected static $instance;

	// Register widget with WordPress.
	function __construct() {
		parent::__construct(
			'ss_product_reset_filters',
			__( 'SS Product Reset Filters', 'sswcaf' ),
			array( 'description' => esc_attr__( 'Reset or apply filters globally.', 'sswcaf' ) )
		);
		self::$instance = false;
	}

	// Front-end display of widget.
	public function widget( $args, $instance ) {

		// Exit if it is not a WooCommerce product archive or shop
		if ( ! ( is_post_type_archive( 'product' ) || is_tax( get_object_taxonomies( 'product' ) ) ) ) {
			return;
		}

		// Exit if widget instance already exists
		if ( ! self::$instance ) {
			self::$instance = true;
		}
		else {
			return;
		}

		$options = get_option( 'sswcaf_settings' );
		if ( isset( $options ) ) {
			$enable_filtering_per_sel = isset( $options['sswcaf_enable_filtering_per_selection'] ) ? $options['sswcaf_enable_filtering_per_selection'] : false;
		}

		// Widget output
		echo $args['before_widget'];

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
		?>
		<p class="product-query-buttons">
        <?php if ( ! $enable_filtering_per_sel ) { ?><button type="button" class="ss-btn btn-primary apply-query"><?php esc_attr_e( 'Apply', 'sswcaf' ); ?></button><?php } ?><button type="button" class="ss-btn reset-all"><?php esc_attr_e( 'Reset All', 'sswcaf' ); ?></button>
		</p>

		<?php echo $args['after_widget'];
	}

	// Back-end widget form
	public function form( $instance ) {
		$title = ! empty( $instance['title'] ) ? $instance['title'] : '';
		?>
		<p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_attr_e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<?php
	}

	// Sanitize widget form values as they are saved
	public function update( $new_instance, $old_instance ) {
		$new_instance = (array) $new_instance;
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		return $instance;
	}

}